<?php

if (!defined('ABSPATH')) {
    exit;
}


if (!function_exists('untdovr_gateway_field_label')) {
    function untdovr_gateway_field_label($field)
    {
        return $field;
    }
}

add_filter('digits_sms_gateways', 'digits_add_gateway_list');
function digits_add_gateway_list($gateways)
{
    return array_merge($gateways, digits_additional_gateways_list());
}

function digits_additional_gateways_list()
{
    return [];
    array(
        'SMSGlobal' => array(
            'value' => 70,
            'require_addon' => 1,
            'inputs' => array(
                untdovr_gateway_field_label('User') => array('text' => true, 'name' => 'user'),
                untdovr_gateway_field_label('Password') => array('text' => true, 'name' => 'password'),
                untdovr_gateway_field_label('Sender') => array('text' => true, 'name' => 'sender', 'optional' => 1),
            ),
        ),
        'kavenegar' => array(
            'value' => 166,
            'require_addon' => 1,
            'label' => 'Kavenegar',
            'inputs' => array(
                untdovr_gateway_field_label('API Key') => array('text' => true, 'name' => 'api_key'),
                untdovr_gateway_field_label('Sender') => array('text' => true, 'name' => 'sender'),
            ),
        ),
        'octopush' => array(
            'value' => 197,
            'require_addon' => 1,
            'label' => 'Octopush',
            'inputs' => array(
                __('API Key') => array(
                    'text' => true,
                    'name' => 'api_key'
                ),
                __('API Login') => array(
                    'text' => true,
                    'name' => 'api_login'
                ),
                __('Sender') => array(
                    'text' => true,
                    'name' => 'sender_name'
                )
            ),
        ),
    );
}

